\name{sepplot}
\alias{sepplot}
\title{Separation plots for nonmetric models}
\description{
  Separation plots for models with nominal and ordinal outcomes}
\usage{
sepplot(fit, ...)
}
\arguments{
  \item{fit}{A fit object returned by glm (with family=binomial), polr,
    or clm2.}
  \item{...}{Additional arguments to be passed to \code{separationplot}
    or \code{sp.categorical}.}
}
\details{
  \code{sepplot} is a simplified frontend to the separation plot
  functions in the \code{separationplot} package, which works directly
  on model fit objects.
}
\author{
  Christopher N. Lawrence \email{lawrencc@debian.org}
}
\seealso{
  \code{\link[separationplot]{separationplot}},
  \code{\link[separationplot]{sp.categorical}}
}
\examples{
data(infert)
model1 <- glm(case ~ spontaneous+induced, data=infert, family=binomial())
summary(model1)
sepplot(model1)

library(MASS)
options(contrasts = c("contr.treatment", "contr.poly"))
house.plr <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
summary(house.plr)
sepplot(house.plr)
}
\keyword{Statistics|models|regression}
