\name{epcp}
\alias{epcp}
\title{Classification accuracy for nonmetric models}
\description{
  Displays classification accuracy for nonmetric dependent variable
  models, including binomial glms, polr, clogit, and oprobit.}
\usage{
epcp(fit, data = NULL, ctable = TRUE, cutoff = 0.5)
}
\arguments{
  \item{fit}{A fit object returned by glm (with family=binomial), polr,
    or oprobit.}
  \item{data}{A data frame to use to find the response variable.  If
    NULL, try to find it from the supplied fit.}
  \item{ctable}{If true, display a classification table in addition to
    the summary data.}
  \item{cutoff}{The cutoff probability between zero and non-zero.  Only
    useful with binary response models.}
}
\details{
  \code{epcp} presents several measures of classification accuracy for
  limited dependent variable models, such as \code{glm}s with the
  binomial family, the proportional-odds logistic regression model
  (\code{polr}), and the ordered probit model (\code{oprobit}).

  Specifically, \code{epcp} presents the percentage of observations correctly
  classified (or predicted) by the model (PCP), the percentage of
  observations in the modal category (PMC), and the proportional
  reduction in error of the estimated model over a naive model
  predicting all observations to be in the modal category (PRE).

  In addition, \code{epcp} presents several probabalistic analogues of these
  measures developed by Herron (2000) (who apparently was unaware of
  Ben-Akiva and Lerman 1985 and Kay and Little 1986, who also developed
  the same classification measure).  These measures are based on the
  level of certainty of the estimated probabilities; for example, a
  predicted probability of .99 would be a more certain prediction than
  .51, yet the standard PCP measure would count both classifications as
  correct (or incorrect).

  Finally, \code{epcp} includes a number of other "pseudo R-square"
  measures for limited dependent variables.
  
  \code{epcp} also presents a classification table (which can be suppressed
  if desired).
}
\author{
  Christopher N. Lawrence \email{lawrencc@debian.org}
}
\note{
  Harvey D. Palmer suggested the extensions to ordinal and categorical
  dependent variable models. (The latter has not yet been ported to \R.)
  
  The ePMC measure suggested in Herron is mathematically equivalent
  to the "proportional chance criterion" suggested by Morrison
  (1969) for evaluating the accuracy of discriminant analysis models.

  Binomial fits with proportions data (i.e. when the response is a two-column
  matrix) are not supported, and will probably lead to error messages.
}
\references{
  Ben-Akiva, M. and S. Lerman.  1985.  \emph{Discrete Choice Analysis.}
  London: MIT Press, 1985.

  Cramer, J.  1999.  "Predictive Performancs of the Binary Logit Model
  in Unbalanced Samples."  \emph{Journal of the Royal Statistical
  Society, Series D (The Statistician)} 48: 85-94.

  Efron, B.  1978.  "Regression and ANOVA with Zero-One Data: Measures
  of Residual Variation."  \emph{Journal of the American Statistical
  Association} 73: 113-212.

  Greene, William.  2002.  \emph{Econometric Analysis.}  Fifth edition.
  New York: Prentice Hall.
  
  Herron, Michael C.  2000.  "Postestimation Uncertainty in Limited
  Dependent Variable Models."  \emph{Political Analysis} 8: 83-98.

  Kay, R. and S. Little.  1996.  "Assessing the Fit of the Logistic
  Model: A Case Study of Children with Haemolytic Uraemic Syndrome."
  \emph{Applied Statistics} 35: 16-30.
  
  Morrison, D. G.  1969.  "On the Interpretation of Discriminant
  Analysis."  \emph{Journal of Marketing Research} 6: 156-63.

  Veall, M. and B. Raj.  1992.  "Pseudo-R2 in the Ordinal Probit Model."
  \emph{Journal of Mathematical Sociology} 16: 333-42.

  Zavonia, R. and W. McElvey. 1975. "A Statistical Model for the
  Analysis of Ordinal Level Dependent Variables."  \emph{Journal of
  Mathematical Sociology} 16 (Summer): 103-120.
}
\seealso{
  \code{\link[survival]{clogit}}, \code{\link[base]{glm}},
  \code{\link[MASS]{polr}}, \code{\link{oprobit}}
}
\examples{
data(infert)
model1 <- glm(case ~ spontaneous+induced, data=infert, family=binomial())
summary(model1)
epcp(model1)
}
\keyword{Statistics|models|regression}
