# Easier interface to separationplot / sp.categorical

sepplot.glm <- function(fit, ...) {
  if (family(fit)$family != "binomial")
    stop("Not a binomial response fit")
  
  pred <- predict(fit, type='response')
  fr <- model.frame(fit)
  actual <- fr[,1]
  
  separationplot(pred, actual, ...)
}

sepplot.clm2 <- function(fit, ...) {
  pred <- predict4clm2(fit)$probs
  actual <- fit$y
  
  sp.categorical(pred, actual, ...)
}

sepplot.polr <- function(fit, ...) {
  pred <- predict(fit, type='probs')
  fr <- model.frame(fit)
  actual <- fr[,1]
  
  sp.categorical(pred, actual, ...)
}

## Works the same(?)
sepplot.clm <- sepplot.polr

sepplot <- function(fit, ...) {
    UseMethod("sepplot")
}
