# Predictions hack for clm2 objects; clm objects work fine

predict4clm2 <- function(fit, data=NULL) {
  if(!inherits(fit, "clm2")) stop("Not a clm2 fit")
  
  rclass <- fit$y
  
  if (is.null(data))
    data <- fit$location
  
  Terms <- attr(fit$location, "terms")
  cl <- attr(Terms, 'dataClasses')
  rterm <- attr(Terms, "response")
  
  ndat <- data[rep(1:nrow(data), each=nlevels(rclass)),]
  ndat[,names(cl)[rterm]] <- rep(gl(nlevels(rclass), 1,
                                    labels=levels(rclass)), nrow(data))
  
  pr <- matrix(predict(fit, newdata=ndat), ncol=nlevels(rclass),
               byrow=TRUE)
  colnames(pr) <- levels(rclass)
  pclass <- ordered(levels(rclass)[apply(pr, 1, which.max)],
                    levels=levels(rclass))

  ret <- list()
  ret$class <- pclass
  ret$probs <- pr

  ret
}
